/*
 * Welcome to your app's main JavaScript file!
 *
 * We recommend including the built version of this JavaScript file
 * (and its CSS file) in your base layout (base.html.twig).
 */

// any CSS you import will output into a single css file (app.css in this case)
import "./styles/admin.scss";
import "bootstrap";
import bsCustomFileInput from "bs-custom-file-input";

bsCustomFileInput.init();

document.addEventListener("DOMContentLoaded", function () {
	// Sélectionner les champs
	const menuSelect = document.getElementById("page_menu");
	const submenuSelect = document.getElementById("page_submenu");

    if (menuSelect && submenuSelect) {
        menuSelect.addEventListener("change", function () {
            const menuId = menuSelect.value;
    
            submenuSelect.innerHTML =
                '<option value="">Choisir un sous-menu</option>';
    
            if (menuId) {
                fetch(`/admin/menu/get-submenus/${menuId}`)
                    .then((response) => response.json())
                    .then((data) => {
                        data.submenus.forEach((submenu) => {
                            const option = document.createElement("option");
                            option.value = submenu.id;
                            option.textContent = submenu.title;
                            submenuSelect.appendChild(option);
                        });
                    })
                    .catch((error) =>
                        console.error(
                            "Erreur lors de la récupération des sous-menus:",
                            error
                        )
                    );
            }
        });
    }
});
