<?php

namespace App\Entity;

use App\Entity\Enum\ContentKey;
use App\Entity\Enum\ContentSection;
use App\Repository\ContentRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ContentRepository::class)]
class Content
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(enumType: ContentSection::class)]
    private ?ContentSection $section = null;

    #[ORM\Column(enumType: ContentKey::class)]
    private ?ContentKey $contentKey = null;

    #[ORM\Column(type: Types::TEXT)]
    private ?string $value = null;

    #[ORM\Column(length: 255)]
    private ?string $description = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getSection(): ?ContentSection
    {
        return $this->section;
    }

    public function setSection(ContentSection $section): static
    {
        $this->section = $section;

        return $this;
    }

    public function getContentKey(): ?ContentKey
    {
        return $this->contentKey;
    }

    public function setContentKey(ContentKey $contentKey): static
    {
        $this->contentKey = $contentKey;

        return $this;
    }

    public function getValue(): ?string
    {
        return $this->value;
    }

    public function setValue(string $value): static
    {
        $this->value = $value;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(string $description): static
    {
        $this->description = $description;

        return $this;
    }
}
