<?php

namespace App\Repository;

use App\Entity\Submenu;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Submenu>
 */
class SubmenuRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Submenu::class);
    }

    public function findMaxRank(): array
    {
        $qb = $this->createQueryBuilder('s')
            ->select('IDENTITY(s.menu) AS menuId, MAX(s.rank) AS maxRank')
            ->groupBy('s.menu');

        return $qb->getQuery()->getResult();
    }
}
