<?php 
namespace App\Service;

use App\Entity\Enum\ContentSection;
use App\Repository\ContentRepository;

class ContentService
{

    public function __construct(private ContentRepository $contentRepository)
    {
    }

    public function getContentBySection(ContentSection $section): array
    {
        $contents = $this->contentRepository->findBy(['section' => $section]);
        $organizedContent = [];
        
        foreach ($contents as $content) {
            $organizedContent[$content->getContentKey()->value] = [
                "id" => $content->getId(),
                "value" => $content->getValue(),
                "description" => $content->getDescription(),
            ];
        }

        return $organizedContent;
    }
}
