<?php

namespace App\Controller\Admin;

use App\Entity\Enum\ContentSection;
use App\Service\ContentService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use App\Form\ContentType;
use Symfony\Component\HttpFoundation\Request;
use App\Entity\Content;
use Doctrine\ORM\EntityManagerInterface;

#[Route('/admin/content')]
class ContentController extends AbstractController
{
    public function __construct(private ContentService $contentService)
    {
    }


    #[Route('/{section}', name: 'app_admin_content')]
    public function contentBySection(ContentSection $section): Response
    {
        $contents = $this->contentService->getContentBySection($section);

        return $this->render('admin/content/index.html.twig', [
            'section' => $section,
            'contents' => $contents,
        ]);
    }

    #[Route('/{id}/edit', name: 'app_admin_content_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, Content $content, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(ContentType::class, $content);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();
            $this->addFlash('success', 'Le texte a été modifié avec succès');

            return $this->redirectToRoute('app_admin_content', ['section' => $content->getSection()->value], Response::HTTP_SEE_OTHER);
        }

        return $this->render('admin/content/edit.html.twig', [
            'content' => $content,
            'section' => $content->getSection(),
            'form' => $form,
        ]);
    }
}
