<?php

namespace App\Form;

use App\Entity\Carousel;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use CKSource\Bundle\CKFinderBundle\Form\Type\CKFinderFileChooserType;

class CarouselType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('title', TextType::class, [
                'label' => 'Titre',
                'attr' => ['class' => 'form-control']
            ])
            ->add('description', TextareaType::class, [
                'required' => false,
                'attr' => [
                    'rows' => 5
                ],
                'constraints' => [
                    new Assert\NotNull(),
                ]
            ])
            ->add('isEnabled',  ChoiceType::class, [
                'choices' => [
                    'Oui' => true,
                    'Non' => false,
                ],
                'expanded' => true,
                'multiple' => false,
                'label' => 'Publié',
            ])
            ->add('image', CKFinderFileChooserType::class, [
                'label' => 'Image',
                'button_text' => 'Browse photos',
                'button_attr' => [
                    'class' => 'btn btn-secondary'
                ],
                'attr' => [
                    'class' => 'form-control', // Classe pour styliser le champ texte
                ],
                'row_attr' => [
                    'class' => 'input-group', // Aligne le champ texte et le bouton
                ],
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Carousel::class,
        ]);
    }
}
