<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;

class ContactType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('name', TextType::class, [
                'label' => 'Nom de l\'élève',
            ])
            ->add('firstname', TextType::class, [
                'label' => 'Prénom de l\'élève',
            ])
            ->add('age', IntegerType::class, [
                'label' => 'Âge de l\'élève',
            ])
            ->add('telephone', TextType::class, [
                'label' => 'Téléphone',
            ])
            ->add('commune', TextType::class, [
                'label' => 'Commune',
            ])
            ->add('studyLevel', ChoiceType::class, [
                'label' => 'Niveau d\'études',
                'choices' => [
                    'Primaire' => [
                        '3P' => '3P',
                        '4P' => '4P',
                        '5P' => '5P',
                        '6P' => '6P',
                        '7P' => '7P',
                        '8P' => '8P',
                    ],
                    'Secondaire' => [
                        '9H' => '9H',
                        '10H' => '10H',
                        '11H' => '11H',
                    ],
                    'CFC' => 'CFC',
                    'ECG' => 'ECG',
                    'Maturité' => 'Maturité',
                ],
            ])
            ->add('learningDifficulty', ChoiceType::class, [
                'label' => 'Difficultés d\'apprentissage',
                'choices' => [
                    'Maths' => 'maths',
                    'Français' => 'francais',
                    'Langues étrangères' => 'langues_etrangeres',
                    'HG' => 'hg',
                    'Autres branches générales' => 'autres_branches_generales',
                    'Formations pour adultes' => 'formations_adultes',
                ],
                'multiple' => true,
                'expanded' => true,
            ])
            ->add('email', EmailType::class, [
                'label' => 'Email',
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            // Configure your form options here
        ]);
    }
}
