<?php

namespace App\Repository;

use App\Entity\HomeCard;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<HomeCard>
 */
class HomeCardRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, HomeCard::class);
    }

    public function findMaxRank(): ?int
    {
        return $this->createQueryBuilder('hc')
            ->select('MAX(hc.rank)')
            ->getQuery()
            ->getSingleScalarResult();
    }
}
